import { useEffect, useState } from 'react';
import Jensen, { BluetoothDevice } from '..';
import './index.css';
import { Logger } from './Logger'

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);
  const [devices, setDevices] = useState<Jensen.BluetoothDevice[]>([]);
  const [greeting, setGreeting] = useState<string|null>(null);

  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.getDeviceInfo().then((info) => {
        alert(info.sn + ' connected');
      });
    };
  }, []);

  const getFilePart = () => {
    const file = files[4];
    const secondsLength = Math.ceil(file.length / file.duration) * 1000;
    console.time('!!!time');
    jensen.getFilePart(file.name, secondsLength * 600, (res) => {
      if (res instanceof Uint8Array) {
        console.timeEnd('!!!time');
      }
    });
  };

  let bluetoothDevices: BluetoothDevice[] = [];
  const bluetoothScan  = async () => {
    setDevices([]);
    setGreeting('scan started at: ' + new Date().toLocaleString());
    let devices = await jensen.scanDevices();
    // console.log(devices);
    setDevices(devices);
    setGreeting(null)
  }

  const connect = async () => {
    await jensen.connect();
    alert(jensen.getModel() + ' connected')
  }

  const disconnectBTDevice = async () => {
    let r = await jensen.disconnectBTDevice();
    console.log(r);
  }

  const clsBtnConnect = {
    height: '30px',
    padding: '0px 20px',
    position: 'absolute',
    right: '0px',
    top: '3px',
    cursor: 'pointer'
  }

  const clsBleDevice = {
    height: '40px',
    lineHeight: '40px', 
    minWidth: '500px',
    position: 'relative',
    display: 'inline-block'
  }

  const clsBleName = {
    fontSize: '16px',
    fontFamily: 'consolas'
  }

  const doConnectBluetooth = async (mac:string) => {
    // alert(mac);
    let rst = await jensen.connectBTDevice(mac, 10);
    alert('connect: ' + rst.result);
  }

  const getTime = async () => {
    let time = await jensen.getTime();
    alert(JSON.stringify(time));
  }

  const listFiles = async () => {
    let fc = await jensen.getFileCount();
    // alert(fc?.count);
    let files = await jensen.listFiles();
    console.log(files);
    setFiles(files)
  }

  const getBluetoothStatus = async () => {
    let info = await jensen.getBluetoothStatus();
    alert(JSON.stringify(info));
  }

  const readFilePartial = async() => {
    if (files.length == 0) return alert('你没有录音文件，或是还没有查询过文件列表');
    let s0 = prompt('请输入需要读取的文件序号，从0开始：', '0');
    let s1 = prompt('请输入开始位置，从0开始：', '0');
    let s2 = prompt('请输入读取字节数量', '32');
    if (s0 && s1 && s2) console.log();
    else return;
    let index = parseInt(s0);
    let offset = parseInt(s1);
    let length = parseInt(s2);
    if (isNaN(index) && isNaN(offset) || isNaN(length)) return;
    if (index >= files.length) return alert('请输入正确的文件序号');
    let file = files[index];
    if (offset < 0 || offset > file.length) return alert('请输入正确的读取开始位置');
    if (length <= 0) return alert('请输入正确的文件读取长度');
    let data = await jensen.readFile(file.name, offset, length);
    console.log(data);
  }

  const updateDeviceTone = async () => {
    let resp = await jensen.requestToneUpdate('826d9bac0b535e7babe02b389327a9f2', 1050688);
    if (resp.code != 0x00) return alert(resp.result);
    
    // 下载文件并完成更新处理
    let xhr = new XMLHttpRequest();
    xhr.open('GET', '/sdfs.bin');
    xhr.setRequestHeader('Content-Type', 'application/octet-stream');
    xhr.responseType = 'arraybuffer';
    xhr.onload = function(e)
    {
      if (this.status != 200) return alert('Http Error: ' + this.status);
      jensen.updateTone(new Uint8Array(this.response), 30).then((info) => {
        alert(JSON.stringify(info));
      });
    }
    xhr.send();
  }

  const updateUAC = async () => {
    // 92e66fd8cfd36f09c83fc61491899307 1024
    let resp = await jensen.requestUACUpdate('92e66fd8cfd36f09c83fc61491899307', 1024);
    if (resp.code != 0x00) return alert(resp.result);
    
    // 下载文件并完成更新处理
    let xhr = new XMLHttpRequest();
    xhr.open('GET', '/UAC.bin');
    xhr.setRequestHeader('Content-Type', 'application/octet-stream');
    xhr.responseType = 'arraybuffer';
    xhr.onload = function(e)
    {
      if (this.status != 200) return alert('Http Error: ' + this.status);
      jensen.updateUAC(new Uint8Array(this.response), 30).then((info) => {
        alert(JSON.stringify(info));
      });
    }
    xhr.send();
  }

  const batteryStatus = async () => {
    let status = await jensen.getBatteryStatus(5);
    alert(JSON.stringify(status));
  }

  let filename = '';
  let filelength = 0;
  const transferFile = async () => {
    if (files == null || files.length == 0) return alert('请先点击List Files');
    let idx = prompt('请输入需要获取的文件序号(从0开始)：', '0');
    if (idx === undefined || idx === null) return;
    let num = parseInt(idx);
    if (isNaN(num) || num < 0 || num >= files.length) return alert('请输入正确的序号');
    let file = files[num];
    filename = file.name;
    filelength = file.length;

    get_file();
  }

  const get_file = () => {
    jensen.getFile(filename, filelength, function(data) {
      console.log('data', data.length);
    }, function(recvBytes) {
      let percent = Math.floor(recvBytes / filelength * 100);
      console.log('progress', percent);
    });
  }

  const writeSN = async () => {
    let nsn = prompt('请输入新的SN号', '');
    if (nsn && nsn.match(/^HD(H1|1E|P1|PM)\w{9}$/gi))
    {
      let rst = await jensen.writeSerialNumber(nsn);
      alert(rst.result);
    }
  }

  const connectx = async () => {
    const usb = (navigator as any).usb;
    usb.onconnect = (evt: any) => {
      console.log(evt);
    }
    usb.getDevices().then(async (devices: any[]) => {
      for (let i = 0; i < devices.length; i++)
      {
        let dev = devices[i];
        await dev.open();
        let jensen = new Jensen(Logger, dev);
        await jensen.initialize();
        let rst = await jensen.getDeviceInfo();
        console.log(rst);
      }
    });
  }

  const test = async () => {
    await jensen.reconnect();
    let rst = await jensen.getDeviceInfo();
    if (rst) alert(rst.sn + ' reconnected...');
    else alert('what the fuck????');
  }

  return (
    <>
    <div style={{ display: 'flex', flexDirection: 'row', gap: '16px', padding: '16px', alignItems: 'center', flexWrap: 'wrap' }}>
      <button onClick={connect}>连接</button>
      <button onClick={getFilePart}>获取文件</button>
      <button onClick={writeSN}>SN写号</button>
      <button onClick={getTime}>获取时间</button>
      <button onClick={listFiles}>文件列表</button>
      <button onClick={transferFile}>传输文件</button>
      <button onClick={batteryStatus}>电池电量</button>
      <button onClick={getBluetoothStatus}>蓝牙连接状态</button>
      <button onClick={bluetoothScan}>蓝牙扫描</button>
      <button onClick={disconnectBTDevice}>蓝牙断开</button>
      <button onClick={readFilePartial}>Read File Partial</button>
      <button onClick={updateDeviceTone}>更新提示音</button>
      <button onClick={updateUAC}>更新UAC</button>
      <button onClick={test}>测试重连</button>
    </div>
    <div id="files" style={{ padding: '0px 0px 0px 30px', marginBottom: '20px' }}>
      <h3>Files: </h3>
      <ol style={{ padding: '0px 0px 0px 30px', 'listStyle': 'none' }}>
        { files.map((item, index) => {
          return <li key={item.name}>{index} - {item?.name}, {item?.length} @ {item.duration}</li>
        })}
      </ol>
    </div>
    <div style={{ padding: '0px 0px 0px 30px', width: '500px' }}>
      <h3>Bluetooth Device List: </h3>
      {
        greeting ? <div>{greeting}</div> : <></>
      }
      {
        devices && devices.length ? (
          devices.map((item, index) => {
            return (
              <div style={clsBleDevice}><span style={clsBleName}>({item.mac}) {item.name}</span><button style={clsBtnConnect} onClick={() => { doConnectBluetooth(item.mac) }}>Connect</button></div>
            );
          })
        ) : (
          <div>no devices...</div>
        )
      }
    </div>
    </>
  );
}
