import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react-swc';

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [react()],
  server: { 
    open: true, 
    hmr: true, 
    port: 6300, 
    host: '0.0.0.0',
    headers: {
      'Cross-Origin-Embedder-Policy': 'require-corp',
      'Cross-Origin-Opener-Policy': 'same-origin',
    },
    proxy: {
      '^/ffmpeg-core/.*': {
        target: 'https://unpkg.com/@ffmpeg/core@0.12.15/dist/umd',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/ffmpeg-core/, '')
      }
    }
  },
  optimizeDeps: {
    exclude: ['@ffmpeg/ffmpeg', '@ffmpeg/util']
  },
  build: {
    rollupOptions: {
      output: {
        manualChunks: {
          ffmpeg: ['@ffmpeg/ffmpeg', '@ffmpeg/util']
        }
      }
    }
  },
  worker: {
    format: 'es'
  }
});
