import { useEffect, useState } from 'react';
import Jensen from '..';
import './index.css';

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);
  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.listFiles(3).then((res) => {
        console.log('files', res);
        res && setFiles(res);
      });
    };
  }, []);

  const downloadFile = () => {
    const file = files[0];
    console.time('---finished');
    jensen.getDeviceInfo();
    jensen.getFile(file.name, file.length, () => {
      console.timeEnd('---finished');
    });
    setTimeout(() => {
      jensen.getDeviceInfo();
    }, 1000);
  };

  return (
    <div style={{ display: 'flex', flexDirection: 'column', gap: '16px', padding: '16px', alignItems: 'center', justifyContent: 'center' }}>
      <button style={{ width: '200px', height: '40px' }} onClick={() => jensen.connect()}>
        Click to connect
      </button>
      <button style={{ width: '200px', height: '40px' }} onClick={downloadFile}>
        get file
      </button>
      <button style={{ width: '200px', height: '40px' }} onClick={() => jensen.getDeviceInfo()}>
        getDeviceInfo
      </button>
    </div>
  );
}
