import { useEffect, useState } from 'react';
import Jensen, { BluetoothDevice } from '..';
import './index.css';
import { Logger } from './Logger'

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);
  const [devices, setDevices] = useState<Jensen.BluetoothDevice[]>([]);
  const [greeting, setGreeting] = useState<string|null>(null);

  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.addWakeupListener(function() {
        console.log('Wake up from sleep?');
      });
      jensen.getDeviceInfo().then((info) => {
        console.log('getDeviceInfo', info);
        alert(info.sn + ' connected');
      }).catch((e) => {
        console.log('getDeviceInfo error', e);
      });
    };
    // jensen.onerror = (e) => {
    //   console.log('onerror', e);
    //   alert('此设备已经在其它已打开的HiNotes网页上建立连接');
    // };
    setInterval(function()
    {
      Logger.info('hearbeat', 'tick', 'xxxx');
    }, 5000);
  }, []);

  const getFilePart = () => {
    const file = files[4];
    const secondsLength = Math.ceil(file.length / file.duration) * 1000;
    console.time('!!!time');
    jensen.getFilePart(file.name, secondsLength * 600, (res) => {
      if (res instanceof Uint8Array) {
        console.timeEnd('!!!time');
      }
    });
  };

  let bluetoothDevices: BluetoothDevice[] = [];
  const bluetoothScan  = async () => {
    setDevices([]);
    setGreeting('scan started at: ' + new Date().toLocaleString());
    let devices = await jensen.scanDevices();
    // console.log(devices);
    setDevices(devices);
    setGreeting(null)
  }
  const connecty = async () => {
    const usb = (navigator as any).usb;
    let conn = await usb.requestDevice({
        filters: [{ vendorId: 0x10d6 }, { vendorId: 0x3887 }]
    });
    if (conn == null) return null;
    // if (conn.opened) throw new Error('device_already_opened');
    await conn.open();
    let jensen = new Jensen(Logger, conn);
    jensen.onerror = (e) => {
      console.log('onerror', e);
      alert('This device has already been connected to another HiNotes webpage');
    };
    await jensen.initialize();
    let dinfo = await jensen.getDeviceInfo();
    if (dinfo)
    console.log('dinfo', dinfo);
    return null;
}

  const connect = async () => {
    await jensen.connect();
    alert(jensen.getModel() + ' connected')
  }

  const disconnectBTDevice = async () => {
    let r = await jensen.disconnectBTDevice();
    console.log(r);
  }

  const clsBtnConnect = {
    height: '30px',
    padding: '0px 20px',
    position: 'absolute',
    right: '0px',
    top: '3px',
    cursor: 'pointer'
  }

  const clsBleDevice = {
    height: '40px',
    lineHeight: '40px', 
    minWidth: '500px',
    position: 'relative',
    display: 'inline-block'
  }

  const clsBleName = {
    fontSize: '16px',
    fontFamily: 'consolas'
  }

  const doConnectBluetooth = async (mac:string) => {
    // alert(mac);
    let rst = await jensen.connectBTDevice(mac, 10);
    alert('connect: ' + rst.result);
  }

  const getTime = async () => {
    let time = await jensen.getTime();
    alert(JSON.stringify(time));
  }

  const listFiles = async () => {
    let fc = await jensen.getFileCount();
    // alert(fc?.count);
    let files = await jensen.listFiles();
    console.log(files);
    setFiles(files)
  }

  const getBluetoothStatus = async () => {
    let info = await jensen.getBluetoothStatus();
    alert(JSON.stringify(info));
  }

  const readFilePartial = async() => {
    if (files.length == 0) return alert('You don\'t have any recording files, or you haven\'t queried the file list');
    let s0 = prompt('Please Input the File Index (Start from 0):', '0');
    let s1 = prompt('Please Input the Start Position (Start from 0):', '0');
    let s2 = prompt('Please Input the Read Byte Count', '32');
    if (s0 && s1 && s2) console.log();
    else return;
    let index = parseInt(s0);
    let offset = parseInt(s1);
    let length = parseInt(s2);
    if (isNaN(index) && isNaN(offset) || isNaN(length)) return;
    if (index >= files.length) return alert('Please Input the Correct File Index');
    let file = files[index];
    if (offset < 0 || offset > file.length) return alert('Please Input the Correct Read Start Position');
    if (length <= 0) return alert('Please Input the Correct Read Byte Count');
    let data = await jensen.readFile(file.name, offset, length);
    console.log(data);
  }

  const updateDeviceTone = async () => {
    let resp = await jensen.requestToneUpdate('826d9bac0b535e7babe02b389327a9f2', 1050688);
    if (resp.code != 0x00) return alert(resp.result);
    
    // 下载文件并完成更新处理
    let xhr = new XMLHttpRequest();
    xhr.open('GET', '/sdfs.bin');
    xhr.setRequestHeader('Content-Type', 'application/octet-stream');
    xhr.responseType = 'arraybuffer';
    xhr.onload = function(e)
    {
      if (this.status != 200) return alert('Http Error: ' + this.status);
      jensen.updateTone(new Uint8Array(this.response), 30).then((info) => {
        alert(JSON.stringify(info));
      });
    }
    xhr.send();
  }

  const updateUAC = async () => {
    // 92e66fd8cfd36f09c83fc61491899307 1024
    let resp = await jensen.requestUACUpdate('92e66fd8cfd36f09c83fc61491899307', 1024);
    if (resp.code != 0x00) return alert(resp.result);
    
    // 下载文件并完成更新处理
    let xhr = new XMLHttpRequest();
    xhr.open('GET', '/UAC.bin');
    xhr.setRequestHeader('Content-Type', 'application/octet-stream');
    xhr.responseType = 'arraybuffer';
    xhr.onload = function(e)
    {
      if (this.status != 200) return alert('Http Error: ' + this.status);
      jensen.updateUAC(new Uint8Array(this.response), 30).then((info) => {
        alert(JSON.stringify(info));
      });
    }
    xhr.send();
  }

  const batteryStatus = async () => {
    let status = await jensen.getBatteryStatus(5);
    alert(JSON.stringify(status));
  }

  let filename = '';
  let filelength = 0;
  const transferFile = async () => {
    if (files == null || files.length == 0) return alert('Please Click "List Files" first');
    let idx = prompt('Please Input the File Index (Start from 0):', '0');
    if (idx === undefined || idx === null) return;
    let num = parseInt(idx);
    if (isNaN(num) || num < 0 || num >= files.length) return alert('Please Input the Correct Index');
    let file = files[num];
    // 2025Jun24-165914-Wip00.hda, 232704 @ 19392
    filename = file.name;
    filelength = file.length;

    get_file();
  }

  const get_file = () => {
    let recvBytes = 0;
    let stime = new Date().getTime();
    jensen.getFile(filename, filelength, function(data) {
      // console.log('data', data.length);
      recvBytes += data.length;
      if (recvBytes >= filelength) {
        let cost = new Date().getTime() - stime;
        alert('File Transfer Complete, Cost: ' + cost + ' ms');
      }
    }, function(recvBytes) {
      let percent = Math.floor(recvBytes / filelength * 100);
      // console.log('progress', percent);
    });
  }

  const writeSN = async () => {
    let nsn = prompt('Please Input the New SN:', '');
    if (nsn && nsn.match(/^HD(H1|1E|P1|PM)\w{9}$/gi))
    {
      let rst = await jensen.writeSerialNumber(nsn);
      alert(rst.result);
    }
  }

  const connectx = async () => {
    const usb = (navigator as any).usb;
    usb.onconnect = (evt: any) => {
      console.log(evt);
    }
    usb.getDevices().then(async (devices: any[]) => {
      for (let i = 0; i < devices.length; i++)
      {
        let dev = devices[i];
        await dev.open();
        let jensen = new Jensen(Logger, dev);
        await jensen.initialize();
        let rst = await jensen.getDeviceInfo();
        console.log(rst);
      }
    });
  }

  const test = async () => {
    await jensen.reconnect();
    let rst = await jensen.getDeviceInfo();
    if (rst) alert(rst.sn + ' reconnected...');
    else alert('Something went wrong...');
  }

  return (
    <>
    <div style={{ display: 'flex', flexDirection: 'row', gap: '16px', padding: '16px', alignItems: 'center', flexWrap: 'wrap' }}>
      <button onClick={connect}>Connect</button>
      <button onClick={getTime}>Get Time</button>
      <button onClick={listFiles}>List Files</button>
      <button onClick={transferFile}>Transfer</button>
      <button onClick={batteryStatus}>Battery</button>
      <button onClick={getBluetoothStatus}>Bluetooth Status</button>
      <button onClick={bluetoothScan}>Bluetooth Scan</button>
      <button onClick={disconnectBTDevice}>Bluetooth Disconnect</button>
      <button onClick={updateDeviceTone}>Update Tone</button>
      <button onClick={updateUAC}>Update UAC</button>
    </div>
    <div id="files" style={{ padding: '0px 0px 0px 30px', marginBottom: '20px' }}>
      <h3>Files: </h3>
      <ol style={{ padding: '0px 0px 0px 30px', 'listStyle': 'none' }}>
        { files.map((item, index) => {
          return <li key={item.name}>{index} - {item?.name}, {item?.length} @ {item.duration}</li>
        })}
      </ol>
    </div>
    <div style={{ padding: '0px 0px 0px 30px', width: '500px' }}>
      <h3>Bluetooth Device List: </h3>
      {
        greeting ? <div>{greeting}</div> : <></>
      }
      {
        devices && devices.length ? (
          devices.map((item, index) => {
            return (
              <div style={clsBleDevice}><span style={clsBleName}>({item.mac}) {item.name}</span><button style={clsBtnConnect} onClick={() => { doConnectBluetooth(item.mac) }}>Connect</button></div>
            );
          })
        ) : (
          <div>no devices...</div>
        )
      }
    </div>
    </>
  );
}
