const Level = {
    debug: 'debug',
    info: 'info',
    error: 'error',
};

export const Logger = {
    messages: [],
    consoleOutput: true,
    info(module, procedure, message) {
        this._append(Level.info, module, procedure, message);
    },
    debug(module, procedure, message) {
        this._append(Level.debug, module, procedure, message);
    },
    error(module, procedure, message) {
        this._append(Level.error, module, procedure, message);
    },
    _append(level, module, procedure, message) {
        let log = {
            level,
            module,
            procedure,
            message: String(message),
            time: new Date().getTime(),
        };
        this.messages.push(log);
        if (this.consoleOutput) {
            this._print(log);
        }
        if (this.messages.length > 15000) this.messages.shift();
    },
    _print(log) {
        let time = new Date(log.time);
        console.info(
            '[' +
                (log.level === 'error' ? 'x' : '*') +
                '][' +
                time.toLocaleString() +
                '](' +
                log.module +
                ' - ' +
                log.procedure +
                ') ' +
                log.message,
        );
    },
    filter(module, procedure) {
        return this.messages.filter((i) => i.module === module && i.procedure === procedure);
    },
    enableConsoleOutput() {
        this.consoleOutput = true;
    },
    disableConsoleOutput() {
        this.consoleOutput = false;
    },
    peek(rows) {
        return this.messages.slice(-rows);
    },
    search(module, procedure, keyword) {
        return this.messages.filter((i) => {
            let r = i.module === module;
            if (!r) return false;
            if (procedure) {
                if (i.procedure !== procedure) return false;
            }
            if (keyword) {
                if (i.message.indexOf(keyword) === -1) return false;
            }
            return true;
        });
    },
};
