import { Jensen as Jen } from './src/jensen';
import { Logger } from './src/utils/utils';
export type DeviceInfo = {
    sn: string;
    versionNumber: number;
    versionCode: string;
};
export type ReturnStruct = {
    common: { result: 'failed' | 'success' };
};
export type FileInfo = {
    name: string;
    createDate: string;
    createTime: string;
    time: Date;
    duration: number;
    length: number;
    signature: string;
};

declare class JensenType {
    constructor(log?: typeof Logger)
    onconnect: Function;
    onmessage: (data: any) => void | null;
    connect: () => Promise<void>;
    init: () => Promise<boolean>;
    getDeviceInfo: (time?: number) => Promise<DeviceInfo>;
    listFiles: (time?: number) => Promise<FileInfo[]>;
    tryconnect: (disableOnConnect?:boolean) => Promise<boolean>;
    getFile: (
        fileName: string,
        length: number,
        on?: (msg: Uint8Array | 'fail') => void,
        onprogress?: (size: number) => void
    ) => void;
    getFileBlock: (
        fileName: string,
        length: number,
        on?: (msg: Uint8Array | 'fail') => void
    ) => Promise<ReturnStruct['common']>;
    requestFirmwareUpgrade: (
        vn: number,
        length: number,
        time?: number
    ) => Promise<{
        result: 'accepted' | 'fail';
    }>;
    beginBNC: (time?: number) => Promise<ReturnStruct['common']>;
    endBNC: (time?: number) => Promise<ReturnStruct['common']>;
    setTime: (date: Date, timeout?: number) => Promise<ReturnStruct['common']>;
    deleteFile: (fileName: string) => Promise<{ result: string }>;
    uploadFirmware: (
        data: number[],
        seconds?: number,
        onProgress?: (cur: number, total: number) => void
    ) => Promise<ReturnStruct['common']>;
    getTime: (time?: number) => Promise<{
        time: string;
    }>;
    getSettings: (
        time?: number
    ) => Promise<{ autoRecord: boolean; autoPlay: boolean; notification?: boolean } | null>;
    setAutoRecord: (enable: boolean, time?: number) => Promise<ReturnStruct['common']>;
    setAutoPlay: (enable: boolean, time?: number) => Promise<ReturnStruct['common']>;
    isConnected: () => boolean;
    setNotification: (state: boolean, time?: number) => Promise<ReturnStruct['common']>;
    ondisconnect?: Function;
    isStopConnectionCheck: boolean;
    getRecordingFile: () => Promise<{
        recording: null | string;
        createTime: string;
        createDate: string;
    }>;
    getCardInfo: (
        seconds?: number
    ) => Promise<{ used: number; capacity: number; status: string }>;
    formatCard: (seconds?: number) => Promise<ReturnStruct['common']>;
    factoryReset: (seconds?: number) => Promise<ReturnStruct['common']>;
    restoreFactorySettings: (seconds?: number) => Promise<ReturnStruct['common']>;
    getModel: () => Promise<string>;
    getFileCount: (seconds?: number) => Promise<{ count: number } | null>;
    recordTestStart: (type: number, seconds?: number) => Promise<ReturnStruct['common']>;
    recordTestEnd: (type: number, seconds?: number) => Promise<ReturnStruct['common']>;
    test: (seconds?: number) => Promise<ReturnStruct['common']>;
    setBluetoothPromptPlay: (
        state: boolean,
        seconds?: number
    ) => Promise<ReturnStruct['common']>;
    writeSerialNumber: (sn: string) => Promise<ReturnStruct['common']>
}


//@ts-ignore
const Jensen = Jen as new (log?: typeof Logger) => JensenType

export default Jensen;
