import { useEffect, useState } from 'react';
import Jensen, { BluetoothDevice } from '..';
import './index.css';

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);

  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.listFiles().then((res) => {
        setFiles(res);
      });
    };
  }, []);

  const getFilePart = () => {
    const file = files[4];
    const secondsLength = Math.ceil(file.length / file.duration) * 1000;
    console.time('!!!time');
    jensen.getFilePart(file.name, secondsLength * 600, (res) => {
      if (res instanceof Uint8Array) {
        console.timeEnd('!!!time');
      }
    });
  };

  let bluetoothDevices: BluetoothDevice[] = [];
  const bluetoothScan  = async () => {
    let devices = await jensen.scanDevices();
    console.log(devices);
    bluetoothDevices = devices;
  }

  const connectBTDevice = async () => {
    let idstr = prompt('请输入需要连接的设备序号(从0开始)：', '');
    let did = parseInt(idstr || '');
    if (isNaN(did)) return alert('已取消');
    let dinfo = bluetoothDevices[did];
    if (dinfo == null || dinfo == undefined) return alert('无效序号');
    let r = await jensen.connectBTDevice(dinfo.mac);
    console.log(r);
  }

  const disconnectBTDevice = async () => {
    let r = await jensen.disconnectBTDevice();
    console.log(r);
  }

  return (
    <div style={{ display: 'flex', flexDirection: 'column', gap: '16px', padding: '16px', alignItems: 'center' }}>
      <button style={{ width: '200px', height: '50px' }} onClick={() => jensen.connect()}>
        Click to connect
      </button>
      <button style={{ width: '200px', height: '50px' }} onClick={getFilePart}>
        get File Part
      </button>
      <button style={{ width : '200px', height : '50px' }} onClick={bluetoothScan}>Bluetooth Scan</button>
      <button style={{ width : '200px', height : '50px' }} onClick={connectBTDevice}>Bluetooth Connect</button>
      <button style={{ width : '200px', height : '50px' }} onClick={disconnectBTDevice}>Bluetooth Disconnect</button>
    </div>
  );
}
