import { useEffect, useState } from 'react';
import Jensen from '..';
import './index.css';

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);

  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.listFiles().then((res) => {
        setFiles(res);
      });
    };
  }, []);

  const getFilePart = () => {
    const file = files[4];
    const secondsLength = Math.ceil(file.length / file.duration) * 1000;
    console.time('!!!time');
    jensen.getFilePart(file.name, secondsLength * 600, (res) => {
      if (res instanceof Uint8Array) {
        console.timeEnd('!!!time');
      }
    });
  };

  return (
    <div style={{ display: 'flex', flexDirection: 'column', gap: '16px', padding: '16px', alignItems: 'center' }}>
      <button style={{ width: '200px', height: '50px' }} onClick={() => jensen.connect()}>
        Click to connect
      </button>
      <button style={{ width: '200px', height: '50px' }} onClick={getFilePart}>
        get File Part
      </button>
    </div>
  );
}
