declare class MessageDecoder {
    constructor();
    decode: (msg: any) => any;
}

export type DeviceInfo = {
    sn: string;
    versionNumber: number;
    versionCode: string;
};

type ReturnStruct = {
    common: { result: 'failed' | 'success' };
};

declare class Jensen {
    onconnect: Function;
    onmessage: (data: any) => void | null;
    constructor();
    connect(): Promise<any, any>;
    init(): Promise<boolean>;
    getDeviceInfo: (time?: number) => Promise<DeviceInfo>;
    listFiles: (time?: number) => Promise<FileInfo[]>;
    tryconnect: () => boolean;
    getFile: (flieName: string, length: number, on?: (msg: Uint8Array | 'fail') => void, onprogress: (size: number) => void) => any;
    requestFirmwareUpgrade: (
        vn: number,
        length: number,
        time?: number,
    ) => Promise<{
        result: 'accepted' | 'fail';
    }>;
    beginBNC: (time?: number) => Promise<ReturnStruct['common']>;
    endBNC: (time?: number) => Promise<ReturnStruct['common']>;
    setTime: (date: Date, timeout?: number) => Promise<ReturnStruct['common']>;
    deleteFile: (fileName: string) => Promise<{ result: string }>;
    uploadFirmware: (
        data: number[],
        seconds?: number,
        onProgress?: (cur: number, total: number) => void,
    ) => Promise<ReturnStruct['common']>;
    getTime: (time?: number) => Promise<{
        time: string;
    }>;
    getSettings: (time?: number) => Promise<{
        autoRecord: boolean;
        autoPlay: boolean;
        notification?: boolean;
    } | null>;
    setAutoRecord: (enable: boolean, time?: number) => Promise<ReturnStruct['common']>;
    setAutoPlay: (enable: boolean, time?: number) => Promise<ReturnStruct['common']>;
    isConnected: () => boolean;
    setNotification: (state: boolean) => void;
    ondisconnect?: Function;
    isStopConnctionCheck: boolean;
    getRecordingFile: () => Promise<{
        recording: null | string;
        createTime: string;
        createDate: string;
    }>;
    getCardInfo: (seconds?: number) => Promise<{ used: number; capacity: number; status: string }>;
    formatCard: (seconds?: number) => Promise<ReturnStruct['common']>;
    factoryReset: (seconds?: number) => Promise<ReturnStruct['common']>;
    getModel: () => Promise<string>;
    getFileCount: (seconds?: number) => Promise<{ count: number } | null>;
}

declare module 'device' {
    export { MessageDecoder, Jensen };
}
