import React, { useEffect, useRef, useState } from 'react';

export default function AudioPreview() {
  const canvasRef = useRef<HTMLCanvasElement>(null);
  const [worker, setWorker] = useState<Worker|null>(null);
  useEffect(() => {
    const canvas = canvasRef.current;
    if (canvas) {
      const ctx = canvas.getContext('2d');
    }

    if (worker) worker.terminate();
    // 创建worker
    let newWorker = new Worker(new URL('./audio-worker.js', import.meta.url));
    setWorker(newWorker);
    return () => {
      newWorker.terminate();
    };
  }, []);


  return (
    <div>
      <canvas ref={canvasRef} width="2000" height="200" style={{ border: '1px solid #ccc' }}></canvas>
    </div>
  );
}