import { useEffect, useState } from 'react';
import Jensen, { BluetoothDevice } from '..';
import './index.css';

const jensen = new Jensen();

export function Home() {
  const [files, setFiles] = useState<Jensen.FileInfo[]>([]);
  const [devices, setDevices] = useState<Jensen.BluetoothDevice[]>([]);
  const [greeting, setGreeting] = useState<string|null>(null);

  useEffect(() => {
    jensen.connect();
    jensen.onconnect = () => {
      console.log('connect successfully');
      jensen.getDeviceInfo().then((info) => {
        alert(info.sn + ' connected');
      });
    };
  }, []);

  const getFilePart = () => {
    const file = files[4];
    const secondsLength = Math.ceil(file.length / file.duration) * 1000;
    console.time('!!!time');
    jensen.getFilePart(file.name, secondsLength * 600, (res) => {
      if (res instanceof Uint8Array) {
        console.timeEnd('!!!time');
      }
    });
  };

  let bluetoothDevices: BluetoothDevice[] = [];
  const bluetoothScan  = async () => {
    setDevices([]);
    setGreeting('scan started at: ' + new Date().toLocaleString());
    let devices = await jensen.scanDevices();
    // console.log(devices);
    setDevices(devices);
    setGreeting(null)
  }

  const disconnectBTDevice = async () => {
    let r = await jensen.disconnectBTDevice();
    console.log(r);
  }

  const clsBtnConnect = {
    height: '30px',
    padding: '0px 20px',
    position: 'absolute',
    right: '0px',
    top: '3px',
    cursor: 'pointer'
  }

  const clsBleDevice = {
    height: '40px',
    lineHeight: '40px', 
    minWidth: '500px',
    position: 'relative',
    display: 'inline-block'
  }

  const clsBleName = {
    fontSize: '16px',
    fontFamily: 'consolas'
  }

  const doConnectBluetooth = async (mac:string) => {
    // alert(mac);
    let rst = await jensen.connectBTDevice(mac, 10);
    alert('connect: ' + rst.result);
  }

  const getTime = async () => {
    let time = await jensen.getTime();
    alert(JSON.stringify(time));
  }

  return (
    <>
    <div style={{ display: 'flex', flexDirection: 'row', gap: '16px', padding: '16px', alignItems: 'center' }}>
      <button style={{ width: '200px', height: '50px' }} onClick={() => jensen.connect()}>
        Connect
      </button>
      <button style={{ width: '200px', height: '50px' }} onClick={getFilePart}>
        get File Part
      </button>
      <button style={{ width: '200px', height: '50px' }} onClick={getTime}>
        Get Time
      </button>
      <button style={{ width : '200px', height : '50px' }} onClick={bluetoothScan}>Bluetooth Scan</button>
      <button style={{ width : '200px', height : '50px' }} onClick={disconnectBTDevice}>Bluetooth Disconnect</button>
    </div>
    <div style={{ padding: '0px 0px 0px 30px', width: '500px' }}>
      <h3>Bluetooth Device List: </h3>
      {
        greeting ? <div>{greeting}</div> : <></>
      }
      {
        devices && devices.length ? (
          devices.map((item, index) => {
            return (
              <div style={clsBleDevice}><span style={clsBleName}>({item.mac}) {item.name}</span><button style={clsBtnConnect} onClick={() => { doConnectBluetooth(item.mac) }}>Connect</button></div>
            );
          })
        ) : (
          <div>no devices...</div>
        )
      }
    </div>
    </>
  );
}
